<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Company extends Model
{
    use SoftDeletes;

    protected $table='companies';
    
    protected $fillable = [
        'name','gstin','email','alternate_email','company_code','generated_by'
    ];

    
	public function getCompanyBillAddress()
    {
		return $this->hasMany(CompanyAddress::class, 'company_id', 'id')->where('type','bill_to')->first();
    }
	
	public function getCompanyShipAddress()
    {
		return $this->hasMany(CompanyAddress::class, 'company_id', 'id')->where('type','ship_to')->first();
    }




}
 