<?php

namespace App\Http\Controllers;
use DB;
use App\attributes;
use Illuminate\Http\Request;

class AttributesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $attributes=attributes::all();
       return view('attributes.index',compact('attributes')); 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        
        return view('attributes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            
            'name' => 'required|unique:attributes,attribute_name',
        ]);
    
        $attributes=new attributes([
             'attribute_name' =>$request->get('name')
        ]);
        $attributes->save();
    
        return redirect()->route('attributes.index')
                        ->with('success','Permission created successfully');
    
     
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function show(attributes $attributes,$id)
    {
        $attributes = attributes::find($id);
        
    
        return view('attributes.show',compact('attributes'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function edit(attributes $attributes,$id)
    {
        $attributes = attributes::find($id);
        return view('attributes.edit',compact('attributes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, attributes $attributes,$id)
    {
        $this->validate($request, [
            'attribute_name' => 'required'
        ]);
    
        $attributes = attributes::find($id);
        $attributes->attribute_name = $request->input('attribute_name');
        $attributes->save();
    
    
        return redirect()->route('attributes.index')
                        ->with('success','Permission updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\attributes  $attributes
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
        $attributes = attributes::find( $id );
        $attributes ->delete();
        return redirect()->route('attributes.index')
                        ->with('success','Permission deleted successfully');
    }



    public function check(Request $request)
    {
        if($request->get('attribute'))
         {
          $email = $request->get('attribute');
          $data = DB::table("attributes")
           ->where('attribute_name', $email)
           ->count();
          if($data > 0)
          {
           echo 'not_unique';
          }
          else
          {
           echo 'unique';
          }
         }
        }
       
}