$(document).ready(function(){
   
   $('.Product_select').select2({
       ajax: {
               url: url_getproduct,
               type: "get",
               dataType: 'json',
               delay: 250,
               data: function (params) {
               return {
                        searchTerm: params.term // search term
                     };
               },
               processResults: function (response) {
               return {
                        results: response
               };		   
		   },
         cache: true
         }
   });
  
   $('.Product_select').on('select2:select', function (e) {
		var product = e.params.data.id;
		$.ajax(url_getproductdetails,{
			type : 'get',
			data :{'product' : product} ,
			success : function(data){
				$(document).find('#product_price').val("₹"+data.price);

            if(data.hsn==null)
            {
               $("#product_HSN").attr("readonly", false); 
            }
            else
            {
               $("#product_HSN").attr("readonly", true); 
            }

            $(document).find('#product_HSN').val(data.hsn);
            $(document).find('#product_SKU').val(data.sku);
            
            // $(document).find('.product_price').attr("data-name",data.product_name);
            // $(document).find('.product_price').attr("data-value",data.price);
            // $(document).find('.product_price').attr("data-id",data.id);

			},
			error: function (jqXhr, textStatus, errorMessage) {
            console.log('Error' + errorMessage);
    }
		});
   });
});