@extends('layouts.main')

@section('content')
 

<section class="content-header">
	
	<h1>Bank Details Management</h1>
    
	<ol class="breadcrumb">
        
		<li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        
		<li><a href="#">Bank Details</a></li>
	
	</ol>

</section>

<hr style="border: 3px groove #3c8dbc;">

<section class="content">

	<div class="row">
	
		<div class="col-xs-12">
		
			<div class="box box-info">
			
				<div class="box-header">

					<div class="alert alert-success hide" id="bankdetail_success"></div>
                
					<div class="alert alert-danger hide" id="bankdetail_danger"></div>
					
					<a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
                
					<a class="btn btn-danger bankdetail_trash" href="#"> Go To Trash</a>

					@can('bank-detail-create')
						<a class="btn btn-success pull-right bankdetail_createbtn" href="#"> Add New Bank Details</a>
					@endcan
				
					@if ($message = Session::get('success'))
				
						<div class="alert alert-success">
							<p>{{ $message }}</p>
						</div>
					
					@endif
				
				</div>
				
				<div class="box-body">
				
					<table class="dataTables_wrapper table table-responsive" id="bankdetail_table">
					
						<thead>
						
							<tr>

								<th class="txt-center">No</th>

								<th class="txt-center">Bank AliasName</th>
								
								<th class="txt-center">Bank Name</th>
								
								<th class="txt-center">Branch Name</th>
								
								<th class="txt-center">IFSC Code</th>
								
								<th class="txt-center">Account No</th>
								
								<th class="txt-center">Action</th>
							
							</tr>
						
						</thead>
						
						<tbody>
						
						@foreach($data as $value)
							
							<tr>

								<td class="txt-center"></td>
								
								<td class="txt-center">{{ $value->bank_aliasname }}</td>
								
								<td class="txt-center">{{ $value->bank_name }}</td>
								
								<td class="txt-center">{{ $value->bank_branch }}</td>
								
								<td class="txt-center">{{ $value->bank_ifsc }}</td>

								<td class="txt-center">{{ $value->ac_no }}</td>
									
								<td class="txt-center">
									
								@can('bank-detail-edit')
                                    <a data-id="{{ $value->id }}" class="bankdetail_editbtn"><i class="fa fa-edit green"></i></a>|
								@endcan
								@can('bank-detail-delete')
                                    <a data-id="{{ $value->id }}" class="bankdetail_trashbtn"><i class="fa fa-trash orange"></i></a> 
								@endcan
								</td>

							</tr>

						@endforeach
						
						</tbody>
					
					</table>
				
				</div>
			
			</div>
		
		</div>
	
	</div>

</section>

			 

@include('bank_detail.create')
@include('bank_detail.edit')
@include('bank_detail.trash')

@endsection