@extends('layouts.backend.main')



@section('content')

<div class="content-wrapper">

    <!-- Content Header (Page header) -->

    <section class="content-header">

        <h1>

            Custom Products

            <small>New Custom Product</small>

        </h1>

        <ol class="breadcrumb">

            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

            <li><a href="{{route('products')}}">Custom Products</a></li>

            <li class="active">Add</li>

        </ol>

    </section>

    <section class="content">

        <div class="box-body">

            {{Form::open(['route'=>'save_custom_product','method'=>'post','id'=>'add_custom_product' ,'enctype' =>'multipart/form-data'])}}

            <div class="row">

                <div class="col-md-3">

                    <div class="form-group">

                        <label>Choose File</label>

                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-3">

                    <div class="form-group">

                            <input type="file" name="file_import" class="file-import" id="file_import">

                            <small class="help-block help-block-for-file-import hide" data-bv-for="file-import" data-bv-result="INVALID" style=""></small>



                    </div>

                    <!-- /.form-group -->

                </div>



            </div>

           

         

            <div class="row">

                <div class="col-md-2">

                    <button  type="submit" class="btn btn-block btn-primary custom-save">Save</button>

                </div>

                <div class="col-md-2">

                    <a  href="{{route('products')}}" type="button" class="btn btn-block btn-danger button-cancel">Cancel</a>

                </div>

            </div>



            {{Form::close()}}

        </div>

    </section>

</div>



@endsection

@section('javascript')

<script>

    

    $(document).on('change', '.file-import', function (e) {

                var _this = $(this);



                e.preventDefault();

                var extension = $('.file-import').val().split('.').pop().toLowerCase();

           if ($.inArray(extension, ['csv', 'xls', 'xlsx','xlsm','xlt','xltx','xltm','xla','xlam']) != -1) {                                        

                    _this.parents('.form-group').removeClass('has-error');

                    $(document).find('.help-block-for-file-import').html('');

                    $(document).find('.help-block-for-file-import').addClass('hide'); 

                                

                    var file_data = $('#file_import').prop('files')[0];



            

                    var form_data = new FormData();

                    form_data.append('file', file_data);

                    $.ajaxSetup({

                        headers: {

                            'X-CSRF-Token': $('meta[name=_token]').attr('content')

                        }

                    });

                                $.ajax({

                                    url : '{{route("save_import_file_data")}}',

                                    type : 'post',

                                    data : form_data ,

                                    contentType: false, // The content type used when sending data to the server.

                                    cache: false, // To unable request pages to be cached

                                    processData: false,

                                    success :function(data){

                                        console.log(data);

                                    },

                                    error :function(data){

                                        console.log('error'.data);

                                    }

                                });



            } else { 

                _this.parents('.form-group').addClass('has-error');

                $(document).find('.help-block-for-file-import').html('Invalid Excel/csv File!');

                $(document).find('.help-block-for-file-import').removeClass('hide');  

                }



       



    });

  

</script>



@endsection