@extends('layouts.main')

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Print Barcode Log
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Print Barcode Log</li>
        </ol>
    </section>
    <section class="content">
        @if(Session::has('successMsg'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> {{Session::get('successMsg')}}</h4>
        </div>
        {{Session::forget('successMsg')}}
        @endif
        @if(Session::has('errorMsg'))
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> {{Session::get('errorMsg')}}</h4>
        </div>
        {{Session::forget('errorMsg')}}
        @endif
       
        <div class="custom-margin">
            <table id="barcode_print_log" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Quantity</th>
                        <th>Scanned By</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($logs))
                    @foreach($logs as $log)
                   
                    <tr>
                        <td>{{$log->custom_products->sku}}</td>
                        <td>{{ucfirst($log->custom_products->name)}}</td>
                        <td>{{$log->quantity}}</td>
                        <td>{{ucfirst($log->users->name)}}</td>
                        <td>{{date("d-m-Y g:i a", strtotime($log->created_at))}}</td>  
                    </tr>
                    @endforeach
                    @else

                    @endif
                </tbody>
            </table>
        </div>
    </section>
@endsection
