@extends('layouts.main')

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">
<section class="content-header">
    <h1>Quotation Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li>Invoice</li>
        <li class="active">Show</li>
    </ol>
</section>
 
<hr style="border: 3px groove #3c8dbc;">

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <a class="btn btn-primary" href="{{ route('invoice-index') }}"> Back</a>                                
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box-body">
                    <div id="invoice">
                        <div class="invoice overflow-auto">
                            <div style="min-width: 600px">
                                <header>
                                    <div class="row">
                                        <div class="col">
                                            <a target="_blank" href="https://www.tannatechbiz.com/">
                                                <img src="/dist/img/test.png" width="180px" height="100px" data-holder-rendered="true" />
                                            </a>
                                        </div>
                                        <div class="col company-details">
                                            <h2 class="name">
                                                <a target="_blank" href="https://www.tannatechbiz.com/"> Tanna TechBiz LLP</a>
                                            </h2>
                                            <div>Vraj-Bhoomi, 22 New Jagnath Plot, Rajkot, Gujarat, 360 001</div>
                                            <div>+919974300810</div>
                                            <div>info@tannatechbiz.com</div>
                                        </div>
                                    </div>
                                </header>
                                <main>
                                    <div class="row contacts">
                                        <div class="col invoice-to">
                                            <div class="text-gray-light"><h3>INVOICE TO:</h3></div>
                                                <h4 class="to">Company Name: {{ $company->name }}</h4>
                                                <h4 class="to">Company code: {{ $company->company_code }}</h4>
                                                <h4 class="to">GST No: {{ $company->gstin }}</h4>
                                            </div>
                    
                                            <div class="col invoice-details">
                                                <h1 class="invoice-id">Invoice No:{{ $invoice->invoice_no }}</h1>
                                                <h3 class="invoice-id">PI No:{{ $invoice->pi_no }}</h3>
                                                <h3 class="invoice-id">Quotation no:{{ $quotation->quotation_no }}</h3>
                                            </div>
                                        </div>
                                    </div>
                
                                    <div class="row contacts">
                                        <div class="col invoice-to">
                                            <div class="text-gray-light"><h3>Billing Address:</h3></div>
                                            <h4 class="to">{{ $company->name }}</h4>
                                            <div class="address add">{{$billing_details->address_line1}},{{$billing_details->address_line2}},{{$billing_details->address_line3}}</div>
                                            <div class="email"><a href="mailto:john@example.com">john@example.com</a></div>
                                        </div>
                    
                                        <div class="col invoice-details">
                                            <div class="text-gray-light"><h3>Shipping Address:</h3></div>
                                            <h4 class="to">{{ $company->name }}</h4>
                                            <div class="address add">{{$shipping_details->address_line1}},{{$shipping_details->address_line2}},{{$shipping_details->address_line3}}</div>
                                            <div class="email"><a href="mailto:john@example.com">john@example.com</a></div>
                                        </div>
                                    </div>
                 
                                    <table id="finaltable" border="0" cellspacing="0" cellpadding="0">
                                        <thead>
                                            <tr>
                                                <th class="text-center">NO.</th>
                                                <th class="text-justify add">Product name</th>
                                                <th class="text-left">HSN</th>
                                                <th class="text-right">Unit Cost</th>
                                                <th class="text-right">Quantity</th>
                                                <th class="text-right">IGST</th>
                                                <th class="text-right specialtotal">TOTAL</th>
                                            </tr>
                                        </thead>

                                        @php
                                            $count=1;
                                            $rowtotal=0;
                                            
                                            $subtotal=0;    
                                            $gsttotal=0;
                                            $grandtotal=0;
                                        @endphp

                                        <tbody id="emergency">
                                            @foreach( $products as $value )
                                            @php
                                                $rowtotal=$value->unit_cost*$value->quantity;
                                                $subtotal=$subtotal+$rowtotal;
                                                $grandtotal=$grandtotal+$rowtotal;
                                            @endphp

                                                <tr>
                                                    <td class="no text-center">{{$count}}</td>
                                                    <td class="text-justify add"><h3>{{ $value->product_name }}</h3></td>
                                                    <td class="text-left">{{ $value->HSN }}</td>
                                                    <td class="unit">₹{{ $value->unit_cost }}</td>
                                                    <td class="qty">{{ $value->quantity }}</td>

                                                    @if($value->c_s_gst=="null")
                                                        <td class="text-right igst">{{ $value->i_gst }}</td>
                                                    @elseif($value->i_gst=="null")
                                                        <td class="text-right igst">{{ $value->c_s_gst }}</td>
                                                    @endif

                                                    
                                                    <td class="total specialtotal">{{$rowtotal}}</td>
                                                </tr>
                                                @php
                                                    $count++;
                                                @endphp
                                            @endforeach
                        
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="no">GST(5%)</td>
                                                <td class="text-left">₹00</td>
                                                <td class="text-left no">GST(18%)</td>
                                                <td class="qty">₹100</td>
                                                <td colspan="1"></td>
                                                <td>Sub Total</td>
                                                <td>₹{{$subtotal}}</td>
                                            </tr>
                                            <tr>
                                                <td class="no">GST(12%)</td>
                                                <td class="text-left">₹100</td>
                                                <td class="text-left no">GST(28%)</td>
                                                <td>₹00</td>
                                                <td colspan="1"></td>
                                                <td>Gst Total</td>
                                                <td>₹200</td>
                                            </tr>
                                            <tr>
                                                <td colspan="5"></td>
                                                <td>GRAND TOTAL</td>
                                                <td>₹400</td>
                                            </tr>
                                        </tfoot>
                                    </table>
                
                                    <div class="notices">
                                        <div><h3>NOTE:</h3></div>
                                        <div class="notice">A finance charge of 1.5% will be made on unpaid balances after 30 days.</div>

                                        <div><h3>PO Number:</h3></div>
                                        <div class="notice">{{$pi_info->po_number}}</div>

                                        <div><h3>Payment Term:</h3></div>
                                        <div class="notice">{{$pi_info->paymnet_term}}</div>
                                    </div>

                                    <div class="notices">
                                        <div><h3>Bank Details:</h3></div>
                                        
                                    </div>

                                </main>
                                <footer>
                                    <button id="printInvoice">click</button>
                                        Invoice was created on a computer and is valid without the signature and seal.
                                </footer>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script>
 $('#printInvoice').click(function(){
            Popup($('.invoice')[0].outerHTML);
            function Popup(data) 
            {
                window.print();
                return true;
            }
        });

</script>

@endsection