@extends('layouts.main')

@section('content')

<section class="content-header">
    <h1>Permission Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="#">Management</a></li>
        <li class="active">Permission</li>
    </ol>
</section>

<hr style="border: 3px groove #3c8dbc;">

            
@if ($message = Session::get('success'))

    <div class="alert alert-success">

        <p>{{ $message }}</p>

    </div>

@endif


<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header">
                    <a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
                    @can('permission-create')
                        <a class="btn btn-success pull-right" href="{{ route('permissions.create') }}"> Create New Permission</a>
                    @endcan
                </div>

                <div class="box-body">
                    <table class="dataTables_wrapper form-inline dt-bootstrap" id="permissions">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Name</th>
                                <th width="280px">Action</th>
                            </tr>
                        </thead>
                        @foreach ($permissions as $key => $permission)
                            <tr>
                                <td></td>
                                <td>{{ $permission->name }}</td>&nbsp
                                <td>
                                    <a href="{{ route('permissions.show',$permission->id) }}"><i class="fa  fa-eye" style="font-size:24px;color:green"></i></a>&nbsp
                                    @can('permission-edit')
                                        <a href="{{ route('permissions.edit',$permission->id) }}"><i class="fa  fa-pencil-square-o" style="font-size:24px;"></i></a>&nbsp
                                    @endcan
                                    @can('permission-delete')
                                        {!! Form::open(['method' => 'DELETE','route' => ['permissions.destroy', $permission->id],'style'=>'display:inline']) !!}
                                        {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                        {!! Form::close() !!}
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</section>





@endsection