@extends('layouts.main')

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Products
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{route('products')}}"><i class="fa fa-dashboard"></i> Products</a></li>
            <li class="active">View</li>
        </ol>
    </section>
    <section class="content">
        <div>
            @if(Session::has('successMsg'))
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <h4><i class="icon fa fa-check"></i> {{Session::get('successMsg')}}</h4>
            </div>
            {{Session::forget('successMsg')}}
            @endif
            @if(Session::has('errorMsg'))
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <h4><i class="icon fa fa-check"></i> {{Session::get('errorMsg')}}</h4>
            </div>
            {{Session::forget('errorMsg')}}
            @endif
            <table id="product_list_detailed" class="table table-bordered table-hover display">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Quantity Received</th>
                        <th>Quantity Dispatch</th>
                        <th>Quantity Sattlement</th>
                        <th>Added By</th>
                        <th>Type</th>
                        <th>Invoice No</th>
                        <th>Invoice Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tfoot>
            <tr>
                <th colspan="2"> Total:</th>
                <th id="received_tot"></th>
                <th id="dispatch_tot"></th>
                <th id="sattelent_tot"></th>
                <th colspan="4"></th>
            </tr>
        </tfoot>
                <tbody>
                    @if(($products))
                    @foreach($products->inventory_rec_dis as $product => $value)
                    <tr>
                        <td>{{$products->sku}}</td>
                        <td>{{$products->name}}</td>
                        @if($value->type == 'receive')
                        <td>{{$value->quantity}}</td>
                        @else
                        <td>-</td>
                        @endif
                        @if($value->type == 'dispatch')
                        <td>{{$value->quantity}}</td>
                        @else
                        <td>-</td>
                        @endif
                        @if($value->type == 'sattlement')
                        <td>{{$value->quantity}}</td>
                        @else
                        <td>-</td>
                        @endif
                        <td>{{ucfirst($value->scanned_by)}}</td>
                        <td>{{ucfirst($value->type)}}</td>
                        <td>{{$value->invoice_no}}</td>
                        <td>{{$value->date}}</td>
                        <td><a href="{{ route('edit_product',[$value->id,$value->type])}}" class="fa fa-edit" title="Edit"></td>
                    </tr>
                    @endforeach
                    @else
                    <tr>No records found</tr>
                    @endif
                </tbody>
            </table>
        </div>
    </section>
@endsection
