@extends('layouts.main')





@section('content')

<section class="content-header">
    <h1> Role Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="#">Management</a></li>
        <li class="active"><a href="#">Roles</a></li>
    </ol>
</section>

<hr style="border: 3px groove #3c8dbc;">

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header">
                    @if ($message = Session::get('success'))
                        <div class="alert alert-success">
                            <p>{{ $message }}</p>
                        </div>
                    @endif
                    <a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
                        <div class="pull-right">
                            @can('role-create')
                                <a class="btn btn-success" href="{{ route('roles.create') }}"> Create New Role</a>
                            @endcan
                        </div>
                </div>
                 
                <div class="box-body">
                
                    
                
                    <table class="dataTables_wrapper form-inline dt-bootstrap" id="roles">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Name</th>
                                <th width="280px">Action</th>
                            </tr>
                        </thead>
                        @foreach ($roles as $key => $role)
                        <tbody>
                            <tr>
                                <td>{{ ++$i }}</td>
                                <td>{{ $role->name }}</td>
                                <td>
                                    <a href="{{ route('roles.show',$role->id) }}"><i class="fa  fa-eye" style="font-size:24px;color:green"></i></a>&nbsp
                                    @can('role-edit')
                                        <a href="{{ route('roles.edit',$role->id) }}"><i class="fa  fa-pencil-square-o" style="font-size:24px;"></i></a>&nbsp
                                    @endcan
                                    @can('role-delete')
                                        {!! Form::open(['method' => 'DELETE','route' => ['roles.destroy', $role->id],'style'=>'display:inline']) !!}
                                        {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                        {!! Form::close() !!}
                                    @endcan
                                </td>
                            </tr>
                        </tbody>
                        @endforeach
                    </table>
                </div>
                    {!! $roles->render() !!}
            </div>
        </div>
    </div>
</section>



@endsection