<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
	
    return view('welcome');
});

Route::get('/thankyou', function () {
    return view('pages.thank_you');
});

Route::get('/profile', function () {
    return view('pages.profile');
});


Route::post('quotation-postmail','MailController@quotationsendmail')->name('quotation-postmail');
Route::post('pi-postmail','MailController@pisendmail')->name('pi-postmail');
Route::post('invoice-postmail','MailController@invoicesendmail')->name('invoice-postmail');
Route::get('quotation-approval/{value}/{id}','QuotationDataController@Approval')->name('quotation-approval');

Route::post('generatenumber','GeneratenumberController@generatenumber')->name('generatenumber');


Auth::routes();

Route::get('home', 'HomeController@index')->name('home');


// Route::group(['middleware' => ['auth']], function() {
    Route::resource('roles','RoleController');
    Route::resource('permissions','PermissionController');
    Route::resource('users','UserController');
    Route::resource('quotations','QuotationController');
    Route::get('/logout', 'HomeController@logout');
    Route::get('getCity', 'DataController@getCity')->name('City');
	Route::get('getStateFromcity', 'DataController@getStateFromCity')->name('findStateFromCity');
	Route::get('getCityState', 'DataController@getCityState')->name('findStateForCity');
	Route::post('city-store/{city?}{state_title?}','DataController@addCity')->name('city-store');

	Route::get('exportFromttb', 'InvoiceController@ExportFromTTB')->name('exportFromttb');
	Route::get('exportFromttbData', 'InvoiceController@getExportDatafromDate')->name('exportFromttbData');
	Route::get('exportFromCPQData', 'InvoiceController@getExportDatafromDateCPQ')->name('exportFromCPQData');
	Route::get('getExportFromCPQData', 'InvoiceController@getExportedData')->name('getExportFromCPQData');

// });


Route::group(['middleware' => ['auth']], function() {
    
    Route::get('iteams','IteamController@index')->name('iteams.index');
    Route::get('createiteam/{id}','IteamController@create')->name('iteams.createiteam');
    Route::patch('storeiteam','IteamController@store')->name('iteams.storeiteam');
    Route::get('showiteam/{id}','IteamController@show')->name('iteams.showiteam');
    Route::get('edititeam/{id}','IteamController@edit')->name('iteams.edititeam');
    Route::patch('updateiteam/{id}','IteamController@update')->name('iteams.updateiteam');
    Route::get('deleteiteam/{id}','IteamController@destroy')->name('iteams.deleteiteam');
    Route::post('checkiteam','IteamController@check')->name('iteams.checkiteam');
    Route::post('visiblecheck','IteamController@visiblecheck')->name('iteams.visiblecheck');
    
});
    
Route::group(['middleware' => ['auth']], function() {
    
    Route::post('storerelation','RelationController@store')->name('iteams.storerelation');
    Route::get('showrelation/{id}','RelationController@show')->name('iteams.showrelation');
    Route::get('createrelation/{id}','RelationController@create')->name('iteams.createrelation');
    Route::get('editrelation/{id}','RelationController@edit')->name('iteams.editrelation');
    

});

Route::group(['middleware' => ['auth']], function() {

    Route::get('attributes','AttributeController@index')->name('attributes.index');
    Route::get('create','AttributeController@create')->name('attributes.create');
    Route::post('store','AttributeController@store')->name('attributes.store');
    Route::get('delete/{id}','AttributeController@destroy')->name('attributes.delete');
    Route::get('edit/{id}','AttributeController@edit')->name('attributes.edit');
    Route::patch('update/{id}','AttributeController@update')->name('attributes.update');
    
    Route::post('check','AttributeController@check')->name('attributes.check');
    Route::post('checkdeletable','AttributeController@checkdeletable')->name('attributes.checkdeletable');
});
 

Route::group(['middleware' => ['auth']], function() {
    
    Route::get('companies','CompanyController@index')->name('companies');
    Route::post('companies-store','CompanyController@store')->name('companies-store');
    Route::post('companies-edit','CompanyController@edit')->name('companies-edit');
    Route::post('companies-update','CompanyController@update')->name('companies-update');
    Route::post('companies-validation','CompanyController@validation')->name('companies-validation');

    
    Route::post('destroycompany','CompanyController@destroy')->name('destroycompany');

    Route::post('destroycompanyperm','CompanyController@destroyperm')->name('destroycompanyperm');
    
    Route::post('trashcompany','CompanyController@trash')->name('trashcompany');

    Route::post('restorecompany','CompanyController@restore')->name('restorecompany');
    

    Route::post('destroyaddress','CompanyController@destroyShippingaddress')->name('destroyaddress');
    
    Route::post('additionofaddress','CompanyController@NewShippingaddress')->name('additionofaddress');
    
});


Route::group(['middleware' => ['auth']], function() {
     
    Route::post('quotation-store','QuotationController@store')->name('quotation-store');

    Route::get('quotation-show/{id}','QuotationController@show')->name('quotation-show');

    

    Route::post('product-store','QuotationController@productstore')->name('product-store');

    Route::get('getCompany', 'QuotationDataController@getCompany')->name('Company');

    Route::get('Companyfortable', 'QuotationDataController@getCompanyfortable')->name('Companyfortable');

    Route::get('getcompanydetails', 'QuotationDataController@getCompanyDetails')->name('getcompanydetails');

    Route::get('findBillingAddressFromCompny', 'QuotationDataController@getCompanyBillingAddress')->name('findBillingAddressFromCompny');
    
    Route::get('findShippingAddressFromCompny', 'QuotationDataController@getCompanyShippingAddress')->name('findShippingAddressFromCompny');
    
    Route::get('invoicelayout/{id}', 'QuotationController@invoicelayout')->name('invoicelayout');

    Route::get('update', 'QuotationController@update')->name('update');

    Route::get('getproduct', 'QuotationDataController@getproduct')->name('getproduct');

    Route::get('getproductdetails', 'QuotationDataController@getproductdetails')->name('getproductdetails');

    Route::get('quotation-mail', 'QuotationController@getmail')->name('quotation-mail');

    Route::post('product-price','QuotationDataController@ckeckprice')->name('product-price');

    Route::post('check-price','QuotationDataController@checkprice')->name('check-price');

    Route::post('get-quotationdetail','QuotationDataController@getquotation')->name('get-quotationdetail');
 
    Route::post('getproductname','QuotationDataController@getproductname')->name('getproductname');

    Route::post('quotation-trash','QuotationController@trash')->name('quotation-trash');

    Route::post('quotation-restore','QuotationController@restore')->name('quotation-restore');

    Route::post('quotation-remove','QuotationController@destroy')->name('quotation-remove');

    Route::post('quotation-removeperm','QuotationController@destroyperm')->name('quotation-removeperm');

    Route::post('quotation-removeunsaved','QuotationController@destroyunsaved')->name('quotation-removeunsaved');

    Route::post('quotation-setapproval','QuotationDataController@setapproval')->name('quotation-setapproval');
    
     
});

 
 

Route::group(['middleware' => ['auth']], function() {
    
    Route::get('pi-index','PIController@index')->name('pi-index');

    Route::get('pi-show/{id}','PIController@show')->name('pi-show');

    Route::post('pi-store','PIController@store')->name('pi-store');
 
    
    Route::post('pi-movetrash','PIController@destroy')->name('pi-movetrash');
    

    Route::post('pi-viewtrash','PIController@trash')->name('pi-viewtrash');

    Route::post('pi-restore','PIController@restore')->name('pi-restore');
     
    Route::post('pi-removeperm','PIController@destroyperm')->name('pi-removeperm');
    
    Route::get('get-quotationforpi', 'PIDataController@getquotation')->name('get-quotationforpi');

    Route::post('getpidetail', 'PIDataController@getpidetail')->name('getpidetail');

    Route::get('getquotationdetailsforpi', 'PIDataController@getquotationdetail')->name('getquotationdetailsforpi');

    Route::post('pi-printoption', 'PIDataController@printoption')->name('pi-printoption');
    

});


Route::group(['middleware' => ['auth']], function() {



    //product routes
    
        Route::get('products', 'ProductController@index')->name('products');
    
        Route::get('products-add', 'ProductController@create')->name('add_product');
    
        Route::post('products-save', 'ProductController@store')->name('save_product');
    
        Route::get('products-search/{type}', 'ProductController@searchProduct')->name('search_product');
    
        
    
        Route::get('products-view/{id}', 'ProductController@viewDetail')->name('view_product_detail');
    
        Route::get('products-edit/{id}/{type}', 'ProductController@edit')->name('edit_product');
    
        Route::post('products-update/{id}/{type}', 'ProductController@update')->name('update_product');
    
        Route::get('product-serial-no', 'ProductController@getProductSerailNo')->name('product_serial_no');
	
		Route::post('set-serial-no-master','ProductController@setSerialNoMaster')->name('set_serial_no_master');
		Route::get('product-serial-no-barcode', 'ProductController@getProductSerailNoForBarcode')->name('product_serial_no_barcode');

        //inventory routes
    
        Route::get('inventory', 'InventoryController@index')->name('inventory');
    
        Route::get('inventory-dispatch', 'InventoryController@dispatchProduct')->name('dispatch_product');
    
        Route::post('inventory/saveDispatch', 'InventoryController@saveDispatchProduct')->name('save_dispatch_product');
    
        Route::get('inventory-sattlement', 'InventoryController@sattelementProduct')->name('sattelment_product');
    
        Route::post('inventory/saveSattelment', 'InventoryController@saveSattelmentProduct')->name('save_sattlement_product');
    
        Route::get('inventory/checkQuantity', 'InventoryController@checkIfQuantity')->name('check_quantity');
    
        Route::get('invoice/search','InventoryController@searchInvoiceWithSKU')->name('search_invoice');
    
        Route::get('print-barcode', 'InventoryController@printBarcode')->name('barcode_print');
    
        Route::post('print-barcode-log', 'InventoryController@logPrintBarcode')->name('log_barcode_print');
    
         Route::get('barcode-log', 'InventoryController@viewBarcodePrintLog')->name('barcode_print_log_view');
    
        
    
    //    custom products routes
    
        Route::get('custom-products', 'CustomProductController@index')->name('custom_products');
    
        Route::get('custom-products-add', 'CustomProductController@create')->name('add_custom_product');
    
        Route::get('custom-products/import', 'CustomProductController@importFile')->name('import_custom_product');
    
        Route::post('custom-products/save-file-data', 'CustomProductController@saveImportFileAndData')->name('save_import_file_data');
    
        Route::post('custom-products/save', 'CustomProductController@store')->name('save_custom_product');
    
        Route::get('custom-products/check-if-product', 'CustomProductController@isExistProduct')->name('is_exist_product');
    
        Route::get('products/delete', 'CustomProductController@destroy')->name('delete_product');
    

    
   
});


Route::group(['middleware' => ['auth']], function() 
{
	Route::post('invoice-store-without-pi','InvoiceController@storeInvoiceWithoutPi')->name('invoice-store-without-pi');

	
	Route::post('product-store-invoice','InvoiceController@productstore')->name('product-store-invoice');

    Route::get('invoice-index','InvoiceController@index')->name('invoice-index');
    Route::get('bank-detail','InvoiceController@getBankDetails')->name('bank-detail');

    Route::post('invoice-store','InvoiceController@store')->name('invoice-store');

    Route::get('invoice-show/{id}','InvoiceController@show')->name('invoice-show');

    Route::post('invoice-shippingshow','InvoiceController@shippingshow')->name('invoice-shippingshow');
    
    Route::post('invoice-shippingadd','InvoiceController@shippingadd')->name('invoice-shippingadd');

    Route::post('invoice-getdetailsforlabel','InvoiceController@detailsforlabel')->name('invoice-getdetailsforlabel');
    
    Route::post('getinvoicedetail', 'InvoiceController@getinvoicedetail')->name('getinvoicedetail');
    
    Route::post('invoice-viewtrash','InvoiceController@trash')->name('invoice-viewtrash');

    Route::post('invoice-movetrash','InvoiceController@destroy')->name('invoice-movetrash');

    Route::post('invoice-removeperm','InvoiceController@destroyperm')->name('invoice-removeperm');

    Route::post('invoice-restore','InvoiceController@restore')->name('invoice-restore');
    Route::post('invoice-cancel','InvoiceController@cancel')->name('invoice-cancel');

    Route::get('invoice-getpi','InvoiceController@getpi')->name('invoice-getpi');

    Route::get('invoice-pidetail','InvoiceController@pidetails')->name('invoice-pidetail');

    Route::post('set-serialno','InvoiceController@setserialno')->name('set-serialno');
    Route::post('get-serial-no','InvoiceController@getSerialNoData')->name('get-serialno');
    

    Route::get('invoice-get-invoice','InvoiceController@getInvocieForSelect2')->name('invoice-for-select2');
    // Route::get('cron','GeneratenumberController@cron')->name('cron');

    Route::get('cron-index','CronController@index')->name('cron-index');

    Route::get('bank_details-index','BankDetailsController@index')->name('bank_details-index');

    Route::post('run-cron','GeneratenumberController@cron')->name('run-cron');

    Route::post('bankdetail-store','BankDetailsController@store')->name('bankdetail-store');

    Route::post('getbankdetail','BankDetailsController@getdetail')->name('getbankdetail');
   
    Route::post('bankdetail-update','BankDetailsController@update')->name('bankdetail-update');

    Route::post('bankdetail-movetrash','BankDetailsController@destroy')->name('bankdetail-movetrash');
    
    Route::post('bankdetail-trash','BankDetailsController@trash')->name('bankdetail-trash');

    Route::post('bankdetail-deleteperm','BankDetailsController@destroyperm')->name('bankdetail-deleteperm');

    Route::post('bankdetail-restore','BankDetailsController@restore')->name('bankdetail-restore');

    
    Route::get('credit-note','CreditNoteController@index')->name('credit-note-index');

});
