<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Company;
use DB;

class CompanyController extends Controller
{
      function __construct()
    {
         $this->middleware('permission:company-list|company-create|company-edit|company-delete', ['only' => ['index','store']]);
         $this->middleware('permission:company-create', ['only' => ['create','store']]);
         $this->middleware('permission:company-edit', ['only' => ['edit','update']]);
         $this->middleware('permission:company-delete', ['only' => ['destroy']]);
    }
    
    public function index(Request $request)
    {
        $data = Company::orderBy('id','DESC')->get();
        return view('companies.index',compact('data'));
    }
    
    public function store(Request $request)
    {
           $company= new Company([
            
            'name'=>$request->company_name,
            'gstin'=>$request->company_cgstin,
            'email'=>$request->company_cemail,
            'company_code'=>$request->company_code,
            'alternate_email'=>$request->alter_email,
            'generated_by'=>$request->generated_by,
        ]);
        $company->save();
		$company_billcity = $request->company_billcity;
		$company_billstate = $request->company_billstate;
		
		if($request->company_billcountry != 'India'){
			$data= (new DataController)->addCity($request,$company_billcity,$company_billstate);
			$company_billcity = $data[0]['city'];
			$company_billstate = $data[0]['state'];
		}
        $company_address_bill=[
                        'company_id'=>  $company->id,
                        'type'=>'bill_to',
                        'alias_name'=>'defulat address', 
                        'person_name'=>$company->name,
                        'address_line1' => $request->company_billaddline1,
                        'address_line2' => $request->company_billaddline2,
                        'address_line3' => $request->company_billaddline3,
                        'city' => $company_billcity,
                        'state' => $company_billstate,
                        'country' => $request->company_billcountry,
                        'pincode' => $request->company_billpincode,
                        'mobile' => $request->company_billmobile,
                        'alternate_mobileno'=>$request->company_billmobile,                    
                    ];

        for($i =0; $i < count($request->company_shipaddressname); $i++)
        {
		if($request->company_shipcountry != 'India'){
			$company_shipcity = $request->company_shipcity[$i];
			$company_shipstate = $request->company_shipstate[$i];
		
			$data= (new DataController)->addCity($request,$company_shipcity,$company_shipstate);
			$company_shipcity = $data[0]['city'];
			$company_shipstate = $data[0]['state'];
		}else{
			$company_shipcity = $request->company_shipcity[$i];
			$company_shipstate = $request->company_shipstate[$i];
		}
			
            $company_address_ship[] = 
            [
                'company_id'=>  $company->id,
                'type'=>'ship_to',
                'alias_name'=>$request->company_shipaddressname[$i],
                'person_name'=>$request->company_receivername[$i],
                'address_line1' => $request->company_shipaddline1[$i],
                'address_line2' => $request->company_shipaddline2[$i],
                'address_line3' => $request->company_shipaddline3[$i],
                'city' => $company_shipcity,
                'state' => $company_shipstate,
                'country' => $request->company_shipcountry[$i],
                'pincode' => $request->company_shippincode[$i],
                'mobile' => $request->company_shipmobile[$i],
                'alternate_mobileno'=>$request->alter_mobile[$i],
                'ship_company_name'=>$request->ship_company_name[$i],
            ];
        }

        $enterddata1=DB::table('company_addresses')->insert($company_address_bill);
       
        $enterddata2=DB::table('company_addresses')->insert($company_address_ship);

        // return response()->json($enterddata);
    }

    public function edit(Request $request)
    {
        $companyid=$request->companyID;
        $company_details=DB::table('companies')
                    ->where('id',$companyid)
                    ->first();
        $company_address=DB::table('company_addresses')
                    ->leftjoin('cities','cities.id','=','company_addresses.city')
                    ->leftjoin('states','states.state_id','=','company_addresses.state')
                    ->where('company_addresses.company_id',$company_details->id)
                    ->get();
             
        return response()->json(['details'=>$company_details,'address'=>$company_address]);
    }

    public function update(Request $request)
    {

        $companyid=$request->companyID;
        $company_emailid=$request->company_email;
        $company_alternateemailid=$request->company_alteremail;

        $billid=$request->company_billid;
        $shipid=$request->company_shipid;
        
        
        $company=
        [
            'email'=>$company_emailid,
            'alternate_email'=>$company_alternateemailid,
        ];


        $company_address_bill=[
                'alias_name'=>'Default Address',
                'address_line1' => $request->company_billaddline1,
                'address_line2' => $request->company_billaddline2,
                'address_line3' => $request->company_billaddline3,
                'city' => $request->company_billcity,
                'state' => $request->company_billstate,
                'country' => $request->company_billcountry,
                'pincode' => $request->company_billpincode,
                'mobile' => $request->company_billmobile,
                'alternate_mobileno'=>$request->company_billmobile,
            ];
 
          
            for($i =0; $i < count($request->company_shipid); $i++)
            {
                $save_data=DB::table('company_addresses')->where('address_id','=',$shipid[$i])->where('company_id','=',$companyid)->where('type','=','ship_to')
                ->update(

                    [
                        'alias_name'=>$request->company_editshipaddname[$i],
                        'person_name'=>$request->company_editshipreceiver[$i],
                        'address_line1' => $request->company_shipaddline1[$i],
                        'address_line2' => $request->company_shipaddline2[$i],
                        'address_line3' => $request->company_shipaddline3[$i],
                        'city' => $request->company_shipcity[$i],
                        'state' => $request->company_shipstate[$i],
                        'country' => $request->company_shipcountry[$i],
                        'pincode' => $request->company_shippincode[$i],
                        'mobile' => $request->company_shipmobile[$i],
                        'alternate_mobileno'=>$request->company_shipaltermobile[$i], 
                    ]

                );
            }

        $save=DB::table('company_addresses')
                ->where('address_id',$billid)
                ->where('company_id',$companyid)
                ->where('type','bill_to')
                ->update($company_address_bill);

        $savecompany=DB::table('companies')
                ->where('id',$companyid)
                ->update($company);
          
                return response()->json(['bill'=>$save,'ship'=>$save_data,'company_detail'=>$savecompany]);                
    }

    public function destroyShippingaddress(Request $request)
    {

        $shippingaddressid=$request->shippingid;

        $data=DB::table('company_addresses')->where('address_id',$shippingaddressid)->delete();
                
        return response()->json($data); 

    }

    public function NewShippingaddress(Request $request)
    {
        $company=$request->companyID;

        for($i =0; $i < count($request->newaddress_name); $i++)
        {
            $company_address_ship[] = 
            [
                'company_id'=>  $company,
                'type'=>'ship_to',
                'alias_name'=>$request->newaddress_name[$i],
                'address_line1' => $request->newaddress_line1[$i],
                'address_line2' => $request->newaddress_line2[$i],
                'address_line3' => $request->newaddress_line3[$i],
                'city' => $request->newaddress_city[$i],
                'state' => $request->newaddress_state[$i],                
                'country' => $request->newaddress_country[$i],
                'pincode' => $request->newaddress_pincode[$i],
                'mobile' => $request->newaddress_mobile[$i],
                'alternate_mobileno'=>$request->newaddress_alternatemobile[$i],
                'person_name'=>$request->newaddress_receivername[$i],
            ];
        }

        $enterddata2=DB::table('company_addresses')->insert($company_address_ship);
        

    }

    public function validation(Request $request)
    {
        if($request->company_name)
        {
         $company_name = $request->company_name;
         $data = DB::table("companies")
          ->where('name', $company_name)
          ->count();
         if($data > 0)
         {
          echo 'not_unique';
         }
         else
         {
          echo 'unique';
         }
        }
        
        if($request->company_emailid)
        {
         $company_emailid = $request->company_emailid;
         $data = DB::table("companies")
          ->where('email', $company_emailid)
          ->count();
         if($data > 0)
         {
          echo 'not_unique';
         }
         else
         {
          echo 'unique';
         }
        }

        if($request->company_gstin)
        {
         $company_gstin = $request->company_gstin;
         $data = DB::table("companies")
          ->where('gstin', $company_gstin)
          ->where('gstin','NOTLIKE',"URP")
          ->count();
         if($data > 0)
         {
          echo 'not_unique';
         }
         else
         {
          echo 'unique';
         }
        }

        if($request->Alter_Email)
        { 
            $company_emailid = $request->Alter_Email;
            $data = DB::table("companies")
          ->where('email', $company_emailid)
          ->count();

         if($data > 0)
         {
          echo 'not_unique';
         }
         else
         {
          echo 'unique';
         }
        }

        if($request->company_code)
        {
            $company_code = $request->company_code;
            $data = DB::table("companies")
                    ->where('company_code', $company_code)
                    ->count();
            if($data > 0)
            {
                echo 'not_unique';
            }
            else
            {
                echo 'unique';
            }
        }
    }
    
    public function destroy(Request $request)
    {

  

        if($request->gettingid)
        {
            $id=$request->gettingid;

            $check=DB::table('quotations')
                    ->where("company_id",$id)
                    ->count();

                    if($check==1)
                    {
                        echo 'not_deleteable';

                    }
                    else if($check==0)
                    {
                        $company=Company::find($id);
            
                        if(!is_null($company))
                        {
                            $company->delete();
                        }
            
                        echo 'Deleted';
                    }            
        }



            
    }

    public function restore(Request $request)
    {
            $id=$request->gettingid;

            $company=Company::withTrashed()->find($id);
            
            if(!is_null($company))
            {
                $company->restore();
            }
            
            return response()->json($company); 

    }

    public function trash(Request $request)
    {

            $company=Company::onlyTrashed()->get();
        
            return response()->json($company); 

    }

    public function destroyperm(Request $request)
    {

        $id=$request->gettingid;

        $company=Company::withTrashed()->find($id);
        
        if(!is_null($company))
        {
            $company->forceDelete();
        }
        
        return response()->json($company); 
        
    }

    

}
