<?php

namespace App\Http\Controllers;
use App\IteamsAttribute;
use App\Iteam;
use App\Attribute;

use Illuminate\Http\Request;
use DB;
use File;
 
class IteamController extends Controller
{
     function __construct()
    {
         $this->middleware('permission:item-list|item-create|item-edit|item-delete', ['only' => ['index','store']]);
         $this->middleware('permission:item-create', ['only' => ['create','store']]);
         $this->middleware('permission:item-edit', ['only' => ['edit','update']]);
         $this->middleware('permission:item-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $iteams=Iteam::all();
       return view('iteams.index',compact('iteams')); 
    }
 
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Iteam $iteams,$id)
    {
       $iteams=Iteam::find($id);
        $attributes=Attribute::get();
        $data= Attribute::join("iteams_attributes","iteams_attributes.attribute_id","=","attributes.id")
            ->where("iteams_attributes.product_id",$id)
            ->get();
        return view('iteams.create',compact('iteams','attributes','data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        for ($i = 0; $i < count($request->get('attri_id')); $i++) {
            $answers[] = [
                'product_id'=>$request->item_id,
                'attribute_id' => $request->attri_id[$i],
                'attribute_value' => $request->attribute_value[$i]
            ];
        }
        IteamsAttribute::insert($answers);
    
        /*$data=DB::table('iteams_attributes')->insert(
            ['attribute_id' => json_encode($request->get('attri_id'))],
            ['attribute_value' => json_encode($request->get('attribute_value'))]
        );*/
        return redirect()->route('iteams.index')
                        ->with('success','Iteam created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Iteam  $iteams
     * @return \Illuminate\Http\Response
     */
    public function show(Iteam $iteams,$id)
    {
        /*$iteams = iteams::find($id);
        return view('iteams.show',compact('iteams'));*/

        $iteams = Iteam::find($id);
        $data= Attribute::join("iteams_attributes","iteams_attributes.attribute_id","=","attributes.id")
            ->where("iteams_attributes.product_id",$id)
            ->get();
        return view('iteams.show',compact('iteams','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Iteam  $iteams
     * @return \Illuminate\Http\Response
     */
    public function edit(Iteam $iteams,$id)
    {
        $iteams = Iteam::find($id);
        $data= Attribute::join("iteams_attributes","iteams_attributes.attribute_id","=","attributes.id")
            ->where("iteams_attributes.product_id",$id)
            ->get();
        return view('iteams.edit',compact('iteams','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Iteams  $iteams
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Iteams $iteams,$id)
    {
         $iteams = Iteam::find($id);
        
         for ($i = 0; $i < count($request->get('attri_id')); $i++) {
            $answers[] = [
                
                'attribute_value' => $request->attribute_value[$i]
            ];
        }
        IteamsAttribute::insert($answers);
    
        return redirect()->route('iteams.index')
                        ->with('success','Permission updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Iteams  $iteams
     * @return \Illuminate\Http\Response
     */
    public function destroy(Iteam $iteams,$id)
    {
        $iteams = Iteam::find( $id );
        $iteams ->delete();
        return redirect()->route('iteams.index')
                        ->with('success','Permission deleted successfully');
    }

   public function visiblecheck(Request $request)
   {
            $IteamId=($request->get('iteamId'));
            
            $storevisiblevalue=Iteam::find($IteamId);
            $storevisiblevalue->visible=$request->get('visiblevalue');
            $storevisiblevalue->save();            

    } 
    


}
