<?php

namespace App\Http\Controllers;

use App\PI;
use App\Quotation;
use DB;
use Illuminate\Http\Request;
 
class PIController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:pi-list|pi-create|pi-edit|pi-delete', ['only' => ['index','store']]);
         $this->middleware('permission:pi-create', ['only' => ['create','store']]);
         $this->middleware('permission:pi-edit', ['only' => ['edit','update']]);
         $this->middleware('permission:pi-delete', ['only' => ['destroy']]);
    }
    /** 
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=Quotation::has('getCompany')
                ->join("p_i_s","p_i_s.quotation_id","=","quotations.id")
                ->where("p_i_s.deleted_at",null)
                ->get(); 
		//print_r($data);exit;
        return view('pi.index',compact('data'));
 
           
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $data= new PI([  
            'pi_no'=>$request->pi_no,
            'quotation_id'=>$request->piquotation_no,
            'bank_id'=>$request->pi_bankdetails,
            'pi_shippingid'=>$request->pi_shippingid,
            'po_number'=>$request->pi_ponumber,
            'paymnet_term'=>$request->pi_paymentterm,
            'generated_by'=>$request->pi_generatedby,
            'note'=>$request->note,
        ]);
        $data->save();
          
        return response()->json($data);
    }
 
    /**
     * Display the specified resource.
     *
     * @param  \App\PI  $pI
     * @return \Illuminate\Http\Response
     */
    public function show(PI $pI,$id)
    {
        $data=PI::find($id);
        
        $quotation=DB::table('quotations')
                ->where('id','=',$data->quotation_id)
                ->first();

        $company_details=DB::table('companies')
                ->where('id','=',$quotation->company_id)
                ->first();
    
        $products_details=DB::table('quotations')
                    ->select('quotations.*','quotation_products.*','custom_products.name')
                    ->join('quotation_products','quotation_products.quotation_no','=','quotations.quotation_no')
                    ->rightjoin('custom_products','custom_products.id','=','quotation_products.item_id')
                    ->where('quotations.quotation_no','=',$quotation->quotation_no)
                    ->get();
 
        $billing_details=DB::table('company_addresses')
                ->leftjoin('cities','cities.id','=','company_addresses.city')
                ->leftjoin('states','states.state_id','=','company_addresses.state')
                ->where('address_id','=',$quotation->billing_id)->first();

        $shipping_details=DB::table('company_addresses')
                        ->leftjoin('cities','cities.id','=','company_addresses.city')
                        ->leftjoin('states','states.state_id','=','company_addresses.state')
                        ->where('address_id','=',$data->pi_shippingid)->first();
                        
        $bank_detail=DB::table('bank_details')
                    ->where('id','=',$data->bank_id)
                    ->first();
       

        return view('pi.show',compact('data','quotation','company_details','products_details','billing_details','shipping_details','bank_detail'));
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\PI  $pI
     * @return \Illuminate\Http\Response
     */
    public function edit(PI $pI)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\PI  $pI
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PI $pI)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\PI  $pI
     * @return \Illuminate\Http\Response
     */
    public function destroy(PI $pI,Request $request)
    {
        $id=$request->gettingid;

            $pi=PI::find($id);
            
            if(!is_null($pi))
            {
                $pi->delete();
            }
            
        return response()->json($pi);
    } 

    public function trash(Request $request)
    {   
        $pi=PI::onlyTrashed()->get();
        
        return response()->json($pi); 
    }

    public function restore(Request $request)
    {
        $id=$request->gettingid;

        $pi=PI::withTrashed()->find($id);
        
        if(!is_null($pi))
        {
            $pi->restore();
        }
        
        return response()->json($pi); 
    }
    
    public function destroyperm(Request $request)
    {
        $id=$request->gettingid;

        $pi=PI::withTrashed()->find($id);
        
        if(!is_null($pi))
        {
            $pi->forceDelete();
        }
        
        return response()->json($pi); 
    }
}
