<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\CustomProduct;
use App\ProductMasterSerialNo;
use Auth;
use Milon\Barcode\DNS1D;
//https://github.com/milon/barcode
use Session;
use App\InventoryInfo;
use DB;

class ProductController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        $products = CustomProduct::with('get_products')->where(['isDeleted' => 0])->get();
        return view('products.list', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('products.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        try {


            $product = new Product();

            $product->product_id = $request->name;
            $product->qty = $request->qty;
            $product->added_by = Auth::user()->id;
            $product->invoice_no = $request->invoice_no;
            $product->invoice_date = date('Y-m-d', strtotime($request->invoice_date));
            $product->save();
            $updateQty = CustomProduct::where(['id' => $request->name])->first();

            CustomProduct::where(['id' => $updateQty->id])->update(['qty' => $updateQty->qty + $request->qty]);

            $inventory = new InventoryInfo();
            $inventory->item_id = $request->name;
            $inventory->date = date('Y-m-d', strtotime($request->invoice_date));
            $inventory->type = 'receive';
            $inventory->quantity = $request->qty;
            $inventory->scanned_by = Auth::user()->id;
            $inventory->invoice_no = $request->invoice_no;
            $inventory->save();

            Session::put('successMsg', 'Product Added!');
        } catch (Exception $ex) {
            Session::put('errorMsg', 'Something went wrong!');
        }
        if (Auth::user()->id != 1) {
            return redirect()->route('home');
        } else {
            return redirect()->route('products');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,$type) {
        $custom_product = InventoryInfo::with('custom_products')->where(['id' => $id])->first();
        $product = Product::with('custom_products')->where(['id' => $id])->first();
        
        $inv_type =  $type; 
        return view('products.edit')->with(['product'=>$custom_product,'type'=>$inv_type]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id , $type) {
        try {
            
            $inventory = InventoryInfo::find($id);
            $dis_qty = $inventory->quantity;
            $invoice = $inventory->invoice_no;
            // $inventory->item_id = $request->name;
            $inventory->date = date('Y-m-d', strtotime($request->invoice_date));
            $inventory->type = $type;
            $inventory->quantity = $request->qty;
            $inventory->scanned_by = Auth::user()->id;
            $inventory->invoice_no = $request->invoice_no;
            $inventory->save();
            if($type == "receive"){
            $updateProduct = Product::where(['product_id'=> $inventory->item_id,'invoice_no'=>$invoice])->first();

            $qty = $updateProduct->qty;

            $updateProduct->invoice_no = $request->invoice_no;
            $updateProduct->invoice_date = date('Y-m-d', strtotime($request->invoice_date));
            $updateProduct->qty = $request->qty;
            $updateProduct->save();

            $updateQty = CustomProduct::where(['id' => $updateProduct->product_id])->first();
            CustomProduct::where(['id' => $updateQty->id])->update(['qty' => $updateQty->qty + $request->qty - $qty]);
            
            $sku = $updateQty->sku;
            }else{
                $updateQty = CustomProduct::where(['id' => $inventory->item_id])->first();
                CustomProduct::where(['id' => $updateQty->id])->update(['qty' => $updateQty->qty - $request->qty + $dis_qty]);
                 $sku = $updateQty->sku;
            }
            Session::put('successMsg', 'Product Updated!');
        } catch (Exception $ex) {
            Session::pviut('errorMsg', 'Something went wrong!');
        }
        
        if (Auth::user()->id != 1) {
            return redirect()->route('home');
        } else {
            return redirect()->route('view_product_detail', [ $sku]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request) {
        
    }

    public function viewDetail($id) {
        $products = CustomProduct::with('inventory_rec_dis')->where(['sku' => $id, 'isDeleted' => 0])->first();

        
        return view('products.view', compact('products'));
    }

    public function searchProduct(Request $request) {
        $type = $request->type;
        $returnType = $type;
        $term = trim($request->q);
        if ($type == 'selectedid') {
            $type = 'id';
            $returnType = 'id';
        } elseif ($type == 'selectedname') {
            $type = 'id';
            $returnType = 'selectedname';
        } elseif ($type == 'sku_') {
            $type = 'sku';
            $returnType = 'name';
        }
        if (empty($term)) {
            return \Response::json([]);
        }
    
        $tags = CustomProduct::where($type, 'LIKE', '%' . $term . '%')->where(['isDeleted' => 0])->limit(5)->get();
        $formatted_tags = [];
        if ($returnType == 'name' || $returnType == 'id') {
            foreach ($tags as $tag) {
                $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->name, 'src' => DNS1D::getBarcodePNG(substr($tag->sku,0,45), "C128", 3, 33, array(1, 1, 1), true)];
            }
        } else {
            foreach ($tags as $tag) {
                $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->sku, 'src' => DNS1D::getBarcodePNG(substr($tag->sku,0,45), "C128", 3, 33, array(1, 1, 1), true)];
            }
        }

        return \Response::json($formatted_tags);
    }
	
	public function getProductSerailNo(Request $request){
		 
		//ProductMasterSerialNo ::with('product_detail')-> where('product_id',$request->product_id)->first();
		$serialNoData =	DB::table('product_master_serial_nos')
                    ->rightjoin("custom_products","custom_products.id","=","product_master_serial_nos.product_id")
                    -> where('custom_products.id',$request->product_id)->first();
		
		return response()->json(['products'=>$serialNoData]);
	}
	
	public function setSerialNoMaster(Request $request){
        $generated_by=$request->generater;
        $product_id=$request->id;
        $serial_no=$request->data;
		
		$isExist = DB::table('product_master_serial_nos')->where('product_id','=',$product_id)->first();
		if(!$isExist){
            $data=DB::table('product_master_serial_nos')
                   ->insert([    
                        'product_id'=>$product_id,
                        'serial_no'=>$serial_no,
                        'generated_by'=>$generated_by,
                    ]);
		}else{
			$data=DB::table('product_master_serial_nos')
					->where('product_id','=',$product_id)
                   ->update([ 
                        'serial_no'=>$serial_no,
                         ]);
		}
	}
	
	public function getProductSerailNoForBarcode(Request $request){
		
		 $src = array();
		//ProductMasterSerialNo ::with('product_detail')-> where('product_id',$request->product_id)->first();
		$serialNoData =	DB::table('product_master_serial_nos')
                    ->rightjoin("custom_products","custom_products.id","=","product_master_serial_nos.product_id")
                    -> where('custom_products.id',$request->product_id)->first(['product_id','name','serial_no']);
		$datas = explode(',',$serialNoData->serial_no);
		$i=0;
		foreach($datas as $data){
			//$src[$i] = DNS1D::getBarcodePNG(substr($data,0,45), "C128", 3, 33, array(1, 1, 1), true);
			$src[$i] = '<img src="data:image/png,' . DNS1D::getBarcodePNG($data, 'C39+') . '" alt="barcode"   />';
			//$src[$i] = '<img src="data:image/png;base64,' . DNS1D::getBarcodePNG($datas[$i], 'C39+',3,33,array(1,1,1), true) . '" alt="barcode"   />';

			$i++;
		}
		
		return response()->json(['products'=>$serialNoData,'src'=>$src]);
	}
		
        
	

}
