<?php

namespace App\Http\Controllers;

use DB;
use App\Iteam;
use App\Relation;

use Illuminate\Http\Request;

class RelationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        
        $item = Iteam::find($id);
        $relatedProdut = Relation::select('relation_id')->where('product_id','=',$id)->get()->toArray();
        $allIteams=Iteam::all();
        $selectedProduct = [];
           foreach($relatedProdut as $key=>$val){
               $selectedProduct[] = $val['relation_id'];
           }
       
       
        return view('relation.create',compact('item','relatedProdut','allIteams','selectedProduct'));   
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $isInsert = false;
        $selectedProduct = [];
        $productid=$request->productid;
        $data=$request->relationdata;
        $isExist = Relation :: where('product_id',$productid)->whereIn('relation_id', $data)->get()->toArray();
        if(count($isExist)){
        foreach($isExist as $key=>$val){
               $selectedProduct[] = $val['relation_id'];
           }
        $answers = [];
        
            for ($i = 0; $i < count($data); $i++) {
            if(!in_array($data[$i],$selectedProduct)){
            $answers[$i] = [
                'product_id'=>$productid,
                'relation_id' => $data[$i],
            ];
            }
           
        }
        }
        else{
            for ($i = 0; $i < count($data); $i++) {
                $answers[$i] = [
                'product_id'=>$productid,
                'relation_id' => $data[$i],
            ];
            }
        }
        
        if(count($answers)){
                   $isInsert = Relation::insert($answers);

        }
        DB::table('relations')->where('product_id',$productid)->whereNotIn('relation_id', $data)->delete();
        
        return response()->json(['isInsert'=>$isInsert]);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\relation  $relation
     * @return \Illuminate\Http\Response
     */
    public function show(relation $relation,$id)
    {
        $iteams = Iteam::find($id);
        $relation= Relation::join("iteams","iteams.id","=","relations.relation_id")
            ->where("relations.product_id","=",$id)
            ->get();
            return view('relation.show',compact('iteams','relation'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\relation  $relation
     * @return \Illuminate\Http\Response
     */
    public function edit(relation $relation)
    {
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\relation  $relation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, relation $relation)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\relation  $relation
     * @return \Illuminate\Http\Response
     */
    public function destroy(relation $relation)
    {
        //
    }

    
}
