<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\User;
use App\Quotation;
use App\ExportedJson;

class Invoice extends Model
{
    use SoftDeletes;
    protected $table='invoices';

    protected $fillable = [
        'invoice_no','pi_no','quotation_no','company_id','courier_name','invoice_status','invoice_type','tracking_id','shipping_date','generated_by','note','billing_id','bank_id','shipping_id','po_number','paymnet_term'
    ];
    
    public function generated_by_user()
    {
        
    return $this->belongsTo(User::class, 'generated_by', 'id')->first();
    
    }
    
    // public function getPi()
    // {
        
    // return $this->belongsTo(PI::class, 'pi_no', 'pi_no')->first();
    
    // }
    
    public function getCompany()
    {
        
    return $this->belongsTo(Company::class, 'company_id', 'id')->first();
    
    }
	
	public function getQuotation(){
		return $this->hasMany(Quotation::class, 'quotation_no', 'quotation_no');	
		}
		
	public function getProducts(){
			return $this->hasMany(InvoiceProduct::class, 'invoice_no', 'invoice_no');	
	}
	
	public function getInvoiceBillAddress($id)
    {
		$address = CompanyAddress::where('address_id',$id)->where('type','bill_to')->first();
		return $address;
		//return $this->belongsTo(CompanyAddress::class, $id ,'address_id')->where('type','bill_to')->first();
    }
	
	public function getInvoiceShipAddress($id)
    {
		
		$address = CompanyAddress::where('address_id',$id)->where('type','ship_to')->first();
			return $address; 
		}
		
	public function getJson(){
			return $this->belongsTo(ExportedJson::class, 'json_id', 'id')->first();	
	}	
}
