<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\QuotationProduct;
use App\Quotation;

class Quotation extends Model
{
    use SoftDeletes;
    protected $table='quotations';
    
    protected $fillable = [
        'quotation_no','company_id','issue_date','due_date','billing_id','shipping_id','generated_by','note'
    ];
    
	public function getProducts(){
		return $this->hasMany(QuotationProduct::class, 'quotation_no', 'quotation_no');	
	}	
	
	public function getCompany(){
		return $this->belongsTo(Company::class, 'company_id', 'id');	
	}
}
 