@extends('layouts.main')

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Inventory
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Inventory</li>
        </ol>
    </section>
    <section class="content">
        @if(Session::has('successMsg'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> {{Session::get('successMsg')}}</h4>
        </div>
        {{Session::forget('successMsg')}}
        @endif
        @if(Session::has('errorMsg'))
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> {{Session::get('errorMsg')}}</h4>
        </div>
        {{Session::forget('errorMsg')}}
        @endif
        <div class="row">
        	@can('dispatch-product')
            <div class="col-md-2">
                <a href="{{ route('dispatch_product')}}" type="button" class="btn btn-block btn-primary">Dispatch Product</a>
            </div>
            @endcan
        	@can('satelment-product')
			<div class="col-md-2">
                <a href="{{ route('sattelment_product')}}" type="button" class="btn btn-block btn-primary">Sattelment Product</a>
            </div>
            @endcan
        </div>
        <div class="custom-margin">
            <table id="inventory_list" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Quantity</th>
                        <th>Scanned By</th>
                        <th>Invoice Date</th>
                        <th>Invoice No</th>
                        <th>Type</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($products))
                    @foreach($products as $product)
                    @if($product->quantity != 0)
                    <tr>
                        <td>{{$product->custom_products->sku}}</td>
                        <td>{{ucfirst($product->custom_products->name)}}</td>
                        <td>{{$product->quantity}}</td>
                        <td>{{ucfirst($product->users->name)}}</td>
                        <td>{{date("d-m-Y g:i a", strtotime($product->date))}}</td>  
                        <td>{{$product->invoice_no}}</td>  
                        <td>{{ucfirst($product->type)}}</td>
                    </tr>
                    @endif
                    @endforeach
                    @else

                    @endif
                </tbody>
            </table>
        </div>
    </section>
@endsection
