@extends('layouts.main')

@section('content')

<section class="content-header">
    <h1>Permission Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="#">Management</a></li>
        <li><a href="/permissions">Permission</a></li>
        <li class="active">Create</li>
    </ol>
</section>

<hr style="border: 3px groove #3c8dbc;">

@if (count($errors) > 0)

    <div class="alert alert-danger">

        <strong>Whoops!</strong> There were some problems with your input.<br><br>

        <ul>

        @foreach ($errors->all() as $error)

            <li>{{ $error }}</li>

        @endforeach

        </ul>

    </div>

@endif

<section class="content">
    <div class="row">
        <div class="col-md-6">
            <div class="box box-info">
                <div class="box-body">
                    {!! Form::open(array('route' => 'permissions.store','method'=>'POST')) !!}
                    
                        <div class="form-group">
                            <lable>Name:</lable>
                                {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                        </div>
                        
                        <div class="box-footer">
                            
                            <a class="btn btn-primary" href="{{ route('permissions.index') }}"> Back</a>
                            <button type="submit" class="btn btn-primary pull-right">Submit</button>
                        
                        </div>
                </div>
            </div>
        </div>
    </div>
</section>

{!! Form::close() !!}







@endsection