@extends('layouts.main')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<section class="content-header">
    <h1>PI Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li class="active">PI</li>
    </ol>
</section> 
<hr style="border: 3px groove #3c8dbc;">
<section class="content"> 
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header">
                        <div class="alert alert-success hide" id="pi_success"></div>
                        <div class="alert alert-danger hide" id="pi_danger"></div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <a class="btn btn-primary" href="{{ route('home') }}"> Back </a>
                                <a class="btn btn-danger pi_trashed" href="#" id="pi_trashed"> Go To Trash </a>

                                @can('pi-create')
                                    <a class="btn btn-success pull-right" href="#" id="pi_create"> Add New PI </a>
                                @endcan

                            </div>
                        </div>
                    </div>
                    @if ($message = Session::get('success'))
                        <div class="alert alert-success">
                            <p>{{ $message }}</p>
                        </div>
                    @endif
                </div>
                <div class="box-body">
                    <!--table class="dataTables_wrapper form-inline dt-bootstrap pi-table" id="quotations"-->
                    <table class="dataTables_wrapper form-inline dt-bootstrap pi-table" id="pis">
                        <thead>
                            <tr>
                                <th class="txt-center">No</th>
                                <th class="txt-center">PI_no</th>
                                <th class="txt-center">Company Name</th>
                                <th class="txt-center">Quotation_no</th>
                                <th class="txt-center">Action</th>
                                <th>Created Date</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($data as $value)
                            <tr id="rowcount">
                                
                                <td class="txt-center"></td>
                                <td class="txt-center">{{$value->pi_no}}</td>
                                <td class="txt-center">{{$value->getCompany->name}}</td>
                                <td class="txt-center">{{$value->quotation_no}}</td>
                                <td class="txt-center">
                                    <a href="#" class="printInvoicepi" data-id="{{'v'.$value->id}}"><i class="fa fa-eye orange"></i></a>|

								   @can('pi-print')
                                        <a href="#" class="printInvoicepi" data-id="{{'p'.$value->id}}"><i class="fa fa-download orange"></i></a>|
                                    @endcan
                                    @can('pi-mail')
                                        <a class="pi_mailbtn" data-id="{{$value->id}}"><i class="fa fa-envelope orange"></i></a>|
                                    @endcan
                                    @can('pi-delete')
                                        <a data-id="{{$value->id}}" class="pi_trashid"><i class="fa fa-trash orange"></i></a>
                                    @endcan

                                </td>
                                <td>{{$value->created_at}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

  
  
@include('pi.create')
@include('pi.mail')
@include('pi.trash')
@include('pi.printoption')
@include('pi.printformate')

 

@endsection