@extends('layouts.main')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<section class="content-header">
    <h1>Quotation Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li class="active">Companies</li>
    </ol>
</section>
 
<hr style="border: 3px groove #3c8dbc;">
 
<section class="content-header">
    <!-- <button type="button" class="btn btn-primary" id="quotation_create">Add New Quotation</button> -->
</section>
<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header">
                        <div class="alert alert-success hide" id="quotation_success"></div>
                        <div class="alert alert-danger hide" id="quotation_danger"></div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
                                <a class="btn btn-danger quotation_trash" href="#" id="quotation_trash"> Go To Trash</a>
                                @can('quotation-create')
                                    <a class="btn btn-success pull-right" href="#" id="quotation_create"> Add New Quotation</a>
                                @endcan
                            </div>
                        </div>
                    </div>
                    @if ($message = Session::get('success'))
                        <div class="alert alert-success">
                            <p>{{ $message }}</p>
                        </div>
                    @endif
                </div>
                <div class="box-body">
                    <table class="dataTables_wrapper form-inline display compact hover order-column row-border stripe dt-bootstrap" id="quotations">
                        <thead>
                            <tr>
                                <th class="txt-center">No</th>
                                <th class="txt-center">Quotation NO</th>
                                <th class="txt-center">Company Code</th>
                                <th class="txt-center">Company name</th>
                                <th class="txt-center">Conformation</th>
                                <th class="txt-center">Save and Email</th>
                                <th>Created Date</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($data as $value) 
                            <tr id="rowcount">
                                <input type="hidden" value="{{$value->id}}" id="testing1">
                                <td class="txt-center"></td>
                                <td class="txt-center">{{$value->quotation_no}}</td>
                                <td class="txt-center">{{$value->company_code}}</td>
                                <td class="txt-center">{{$value->name}} </td>
                                <td>
                                
                                <!-- <select id="Conformation" name="Conformation[]" data-id="">
                                <option disabled selected value> -- Give Conformation -- </option>
                                    <option id="{{$value->id}}" value="approved">approved</option>
                                    <option id="{{$value->id}}" value="disapproved">disapproved</option>
                                </select> -->
                                    <!-- @if($value->conformation=="")
                                            Approval Pendding
                                    @elseif($value->conformation=="approved")
                                            
                                    @elseif($value->conformation=="disapproved")
                                            Rejected
                                    @endif -->
                                    
                                </td>
                                
                                <td class="txt-center">
                                    <a href="#" class="printInvoice" data-id="{{'v'.$value->id}}"><i class="fa fa-eye orange"></i></a>|

                                    @can('quotation-print')
                                        <a href="#" class="printInvoice" data-id="{{'p'.$value->id}}"><i class="fa fa-download orange"></i></a>|
                                    @endcan
                                    @can('quotation-mail')
                                        <a class="quotation_mailbtn" data-id="{{$value->id}}"><i class="fa fa-envelope orange"></i></a>|
                                    @endcan
                                    @can('quotation-delete')
                                        <a data-id="{{$value->id}}" class="quotation_trashid"><i class="fa fa-trash orange"></i></a>
                                    @endcan
                                
                                </td>
                                <td>{{$value->created_at}} </td>
                                
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
</section>



@include('quotations.create')
@include('quotations.mail')
@include('quotations.mailforapproval')
@include('quotations.trash')
@include('quotations.printformate')
@include('quotations.printoption')



@endsection