@extends('layouts.main')





@section('content')


<section class="content-header">
    <h1>Users Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="#">Management</a></li>
        <li class="active">Users</li>

    </ol>
</section>
<hr style="border: 3px groove #3c8dbc;">



<div class="row">

    <div class="col-lg-12 margin-tb">
          <div class="pull-right">

            

        </div>

    </div>

</div>





@if ($message = Session::get('success'))

<div class="alert alert-success">

  <p>{{ $message }}</p>

</div>

@endif


<section class="content">
  <div class="row">
    <div class="col-xs-12">
      <div class="box box-info">
        <div class="box-header">
          <a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
            <div class="pull-right">
              @can('user-create')
                <a class="btn btn-success" href="{{ route('users.create') }}"> Create New User</a>
              @endcan
            </div>
        </div>
        <div class="box-body">
          
          <table class="dataTables_wrapper form-inline dt-bootstrap" id="users">
            <thead>
              <tr>
                <th>No</th>
                <th>Name</th>
                <th>Email</th>
                <th>Roles</th>
                <th width="280px">Action</th>
              </tr>
            </thead>
            @foreach ($data as $key => $user)
              <tr>
                <td>{{ ++$i }}</td>
                <td>{{ ucfirst($user->name) }}</td>
                <td>{{ $user->email }}</td>
                <td>
                  @if(!empty($user->getRoleNames()))
                    @foreach($user->getRoleNames() as $v)
                      <label class="badge badge-success">{{ $v }}</label>
                    @endforeach
                  @endif
                </td>
                <td>
                  <a href="{{ route('users.show',$user->id) }}"><i class="fa  fa-eye" style="font-size:24px;color:green;"></i></a>
                  @can('user-edit')
                    <a href="{{ route('users.edit',$user->id) }}"><i class="fa  fa-pencil-square-o" style="font-size:24px;"></i></a>
                  @endcan
                  @can('user-delete')
                    {!! Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']) !!}
                    <?php if(\Auth::user()->email !=$user->email){?>
                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                    {!! Form::close() !!}
                    <?php } ?>
                  @endcan
                  </td>
              </tr>
            @endforeach
          </table>
          {!! $data->render() !!}
        </div>
      </div>
    </div>
  </div>
</section>



@endsection