

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Print Barcode Log
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Print Barcode Log</li>
        </ol>
    </section>
    <section class="content">
        <?php if(Session::has('successMsg')): ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('successMsg')); ?></h4>
        </div>
        <?php echo e(Session::forget('successMsg')); ?>

        <?php endif; ?>
        <?php if(Session::has('errorMsg')): ?>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('errorMsg')); ?></h4>
        </div>
        <?php echo e(Session::forget('errorMsg')); ?>

        <?php endif; ?>
       
        <div class="custom-margin">
            <table id="barcode_print_log" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Quantity</th>
                        <th>Scanned By</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($logs)): ?>
                    <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   
                    <tr>
                        <td><?php echo e($log->custom_products->sku); ?></td>
                        <td><?php echo e(ucfirst($log->custom_products->name)); ?></td>
                        <td><?php echo e($log->quantity); ?></td>
                        <td><?php echo e(ucfirst($log->users->name)); ?></td>
                        <td><?php echo e(date("d-m-Y g:i a", strtotime($log->created_at))); ?></td>  
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>

                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tannatech/public_html/cpq/resources/views/inventory/view_barcode_print_log.blade.php ENDPATH**/ ?>