

<?php $__env->startSection('content'); ?>
<style>
    .upload-btn-wrapper {
  position: relative;
  overflow: hidden;
  display: inline-block;
}


.upload-btn-wrapper input[type=file] {
  font-size: 100px;
  position: absolute;
  left: 0;
  top: 0;
  opacity: 0;
}
</style>
<div class="content-wrapper">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Products
            <small>New Product</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(route('products')); ?>">Products</a></li>
            <li class="active">Add</li>
        </ol>
    </section>
    <section class="content">
        <div class="box-body">
            <?php echo e(Form::open(['route'=>'save_product','method'=>'post'])); ?>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Name</label>
                        <select class="form-control select2" id="select2-name" style="width: 100%;" name="name">
                        </select>
                    </div>
                    <!-- /.form-group -->
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>SKU</label>
                        <select class="form-control select2-sku" style="width: 100%;" name="sku">
                        </select>
                    </div>
                    <!-- /.form-group -->
                </div>

            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Invoice No</label>
                        <input class="form-control invoice-no" type="text" placeholder="Invoice No" name="invoice_no">
                    </div>
                    <!-- /.form-group -->
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Invoice Date</label>
                        <input type="text" class="form-control pull-right~date-only-custom datepicker-invoice" id="datepicker_invoice" name='invoice_date' placeholder="Select Date">
                    </div>
                    <!-- /.form-group -->
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Quantity</label>
                        <input class="form-control print-qty number-only-custom" type="text" placeholder="Quantity" name="qty">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group custom-print-barcode-parent" id="custom-print-barcode-parent">
                        <img alt="Barcode" src="" class="custom-barcode" width="160px" height="50px">
                    </div>
                </div>
                <div class="col-md-2">
                    <button  type="button" class="btn btn-block btn-primary custom-print-barcode">Print Barcode</button>
                </div>
                <div class="col-md-2">
                    <button  type="submit" class="btn btn-block btn-primary disabled hidden custom-save">Save</button>
                </div>
                <div class="col-md-2">
                    <a  href="<?php echo e(route('products')); ?>" type="button" class="btn btn-block btn-danger button-cancel">Cancel</a>
                </div>
            </div>

            <?php echo e(Form::close()); ?>

        </div>
        <br>
        <br>
        <hr style="border-top: 4px solid #9c9494;">
         <div class="row">
                <div class="col-md-4 col-md-offset-2">
                    <a  type="button" class="btn btn-block btn-primary " href="<?php echo e(route('custom_products')); ?>">Can't Find your Product? Add New</a>
                </div>
                <div class="col-md-4">
                    <!--<a  href="<?php echo e(route('products')); ?>" type="button" class="btn btn-block btn-primary">Import CSV file</a>-->
                    
                    <?php echo e(Form::open(['route'=>'save_import_file_data','method'=>'post','id'=>'add_custom_product' ,'enctype' =>'multipart/form-data'])); ?>

                    <input type="hidden" name="_token" value="<?php echo e(Session::token()); ?>">

                    <div class="row">
                        <!--<div class="col-md-3">-->
                        <!--    <div class="form-group">-->
                                <!--<label >have CSV? Browse Here</label>-->
                        <!--    </div>-->
                            <!-- /.form-group -->
                        <!--</div>-->
                        <!--<div class="col-md-3">-->
                        <img src="<?php echo e(asset('public/images/Loadingsome.gif')); ?>" alt='loading' style="position: fixed; top: 43%;left: 60%; width: 176px !important;"  id="loading" hidden/> 
                            <div class="form-group">
                                    
                                    <div class="upload-btn-wrapper">
                                    <button class="btn btn-block btn-primary">Have CSV? Browse Here</button>
                                    <input type="file" name="file_import" class="file-import" id="file_import">
                                    </div>
                                    <small class="help-block help-block-for-file-import hide" data-bv-for="file-import" data-bv-result="INVALID" style=""></small>
        
                            </div>
                            <!-- /.form-group -->
                        <!--</div>-->
        
                    </div>
                  
                      <?php echo e(Form::close()); ?>

                      
                      

                </div>
                </div>
                  <div class="row">
                      
                        <div class="hide file-upload-message"></div>
                        <div class="hide file-upload-message-data"></div>
                    </div>
            </div>
    </section>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>

<script>
    $('#datepicker_invoice').datepicker({
        autoclose: true,
    });

    $('.select2').select2({
        placeholder: "Enter product name...",
        minimumInputLength: 2,
        ajax: {
            url: "<?php echo e(route('search_product','name')); ?>",
            dataType: 'json',
            data: function (params) {
                return {
                    q: $.trim(params.term)
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        }
    });
    $('.select2-sku').select2({
        placeholder: "Enter Product SKU...",
        minimumInputLength: 2,
        ajax: {
            url: "<?php echo e(route('search_product','sku')); ?>",
            dataType: 'json',
            data: function (params) {
                return {
                    q: $.trim(params.term)
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        }
    });
    $(document).ready(function () {

        $(".select2-sku").on("change", function (e) {
            var resdata = $(this).val();
            var sku = '';
            var src = '';
            console.log(src);
            $.ajax({
                method: 'get',
                url: "<?php echo e(route('search_product','selectedid')); ?>",
                data: {q: resdata},
                success: function (data) {
                    var newOption = new Option(data[0].text, data[0].id, true, true);
                    $(document).find('#select2-name').append(newOption);
                    sku = $(".select2-sku option:selected").text();
                    console.log(data[0].src);
                    $('.custom-barcode').attr('src', 'data:image/png;base64,' + data[0].src);
                },
                error: function (data) {
                    console.log('here2');
                },
            });
        });
        $(".select2").on("change", function (e) {
            var resdata = $(this).val();
            var sku = '';
            $.ajax({
                method: 'get',
                url: "<?php echo e(route('search_product','selectedname')); ?>",
                data: {q: resdata},
                success: function (data) {
                    var newOption = new Option(data[0].text, data[0].id, true, true);
                    $(document).find('.select2-sku').append(newOption);
                    sku = data[0].text;
                    $('.custom-barcode').attr('src', 'data:image/png;base64,' + data[0].src);
                },
                error: function (data) {
                    console.log('here2');
                },
            });

        });
    });
    $(document).on('click', '.custom-print-barcode', function () {
        var divContents_name = $("#select2-name option:selected").text();
        var divContents = document.getElementById("custom-print-barcode-parent");
        var qty = $('.print-qty').val();
        var divContents_invoice = $('.invoice-no').val();
        var divContents_date = $('.datepicker-invoice').val();
        
        if (qty == '') {
            alert('Please enter quantity');
        }else if(divContents == ''){
            alert('Please select SKU');
        }else if(divContents_name == ''){
            alert('Please select name');
        }else if(divContents_date == ''){
            alert('Please enter date');
        }else if(divContents_invoice == ''){
            alert('Please enter invoice number');
        }else{
            var newWin = window.open('TannaTechBiz', 'Print-Window');
            newWin.document.open();
            newWin.document.write('<html>\n\
             <title>TannaTechBiz</title>\n\
             <body onload="window.print()">\n\
             <table style="margin-left=40px !important"><tr>');
            for (var i = 1; i <= qty; i++) {
                newWin.document.write('<td style="padding:10px;text-align:center">' + divContents.innerHTML + '<br><r>' + divContents_name + '</td>');
                if (i % 3 == 0) {
                    newWin.document.write('</tr><tr>');
                }
            }
            newWin.document.write('</tr></table>\n\
             </body>\n\
             </html>');
            newWin.document.close();
            setTimeout(function () {
                newWin.close();
            }, 10);
            $(this).addClass('hidden');
            $('.custom-save').removeClass('disabled');
            $('.custom-save').removeClass('hidden');
        } 
    });
     $(document).on('change', '.file-import', function (e) {
                var _this = $(this);

                e.preventDefault();
                var extension = $('.file-import').val().split('.').pop().toLowerCase();
           if ($.inArray(extension, ['csv', 'xls']) != -1) {                                        
                    _this.parents('.form-group').removeClass('has-error');
                    $(document).find('.help-block-for-file-import').html('');
                    $(document).find('.help-block-for-file-import').addClass('hide'); 
                        
                        
                    // $('#add_custom_product').submit();            
                    var file_data = $('#file_import').prop('files')[0];

            
                    var form_data = new FormData();
                    form_data.append("_token","<?php echo e(csrf_token()); ?>");
                    form_data.append('file_import', file_data);
                    console.log(form_data);
                   
                                $.ajax({
                                    url : '<?php echo e(route("save_import_file_data")); ?>',
                                    type : 'post',
                                    data : form_data ,
                                    contentType: false, // The content type used when sending data to the server.
                                    cache: false, // To unable request pages to be cached
                                    processData: false,
                                    beforeSend: function(){
                                       
                                     $("#loading").show();
                                    $('.upload-btn-wrapper').hide();    
                                   },
                                   complete: function(){
                                     $("#loading").hide();
                                   },
                                    success :function(data){
                                            $('.upload-btn-wrapper').show();    

                                        setTimeout( "$('#loading').hide();", 6000);

                                        $(document).find(".file-upload-message").removeClass("hide");
                                        if(data.isValid){
                                            $(document).find(".file-upload-message").text(data.message);
                                        }else{
                                             $(document).find(".file-upload-message").text(data.message);
                                             if(data.returnData)
                                             {              $(document).find(".file-upload-message-data").removeClass("hide");
                                                            $('.file-upload-message-data').append('<table border="1"><tr><td  width="186">' + " Product" + '</td><td width="186">' + "Sku" + '</td><td width="186">' + "Stock" + '</td></tr>');

                                                         $.each( data.returnData, function( i, val ) {
                                                            
                                                            $('.file-upload-message-data').append('<table border="1"><tr><td  width="186">' + val['product'] + '</td><td  width="186">' +  val['sku'] + '</td><td width="186">' +  val['stock'] + '</td></tr>');

                                                        });
                                                        
                                                        $(document).find(".file-upload-message-data").append("</table>");
                                             }

                                        }
                                        // setTimeout(function() {
                                        //   location.reload();
                                        // }, 7000);
                                        
                                        $("#add_custom_product").trigger("reset");
                                        
                                    },
                                    error :function(data){
                                        
                                        console.log('error'.data);
                                    }
                                });

            } else { 
                _this.parents('.form-group').addClass('has-error');
                $(document).find('.help-block-for-file-import').html('Invalid Excel/csv File!');
                $(document).find('.help-block-for-file-import').removeClass('hide');  
                }

       

    });
    

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp-8\htdocs\cpq\resources\views/products/add.blade.php ENDPATH**/ ?>