

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Inventory
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Inventory</li>
        </ol>
    </section>
    <section class="content">
        <?php if(Session::has('successMsg')): ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('successMsg')); ?></h4>
        </div>
        <?php echo e(Session::forget('successMsg')); ?>

        <?php endif; ?>
        <?php if(Session::has('errorMsg')): ?>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('errorMsg')); ?></h4>
        </div>
        <?php echo e(Session::forget('errorMsg')); ?>

        <?php endif; ?>
        <div class="row">
            <div class="col-md-2">
                <a href="<?php echo e(route('dispatch_product')); ?>" type="button" class="btn btn-block btn-primary">Dispatch Product</a>
            </div>
        </div>
        <div class="custom-margin">
            <table id="inventory_list" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Quantity</th>
                        <th>Scanned By</th>
                        <th>Invoice Date</th>
                        <th>Invoice No</th>
                        <th>Type</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($products)): ?>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($product->quantity != 0): ?>
                    <tr>
                        <td><?php echo e($product->custom_products->sku); ?></td>
                        <td><?php echo e(ucfirst($product->custom_products->name)); ?></td>
                        <td><?php echo e($product->quantity); ?></td>
                        <td><?php echo e(ucfirst($product->users->name)); ?></td>
                        <td><?php echo e(date("d-m-Y g:i a", strtotime($product->date))); ?></td>  
                        <td><?php echo e($product->invoice_no); ?></td>  
                        <td><?php echo e(ucfirst($product->type)); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>

                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tannatech/public_html/cpq/resources/views/inventory/list.blade.php ENDPATH**/ ?>