

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Custom Products
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Custom Products</li>
        </ol>
    </section>
    <section class="content">
        <?php if(Session::has('successMsg')): ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('successMsg')); ?></h4>
        </div>
        <?php echo e(Session::forget('successMsg')); ?>

        <?php endif; ?>
        <?php if(Session::has('errorMsg')): ?>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('errorMsg')); ?></h4>
        </div>
        <?php echo e(Session::forget('errorMsg')); ?>

        <?php endif; ?>
        <div class="row">
            <div class="col-md-2">
                <a href="<?php echo e(route('add_custom_product')); ?>" type="button" class="btn btn-block btn-primary">Add New Product</a>
            </div>
             <div class="col-md-2">
                             <?php echo e(Form::open(['route'=>'save_import_file_data','method'=>'post','id'=>'save_import_file_data' ,'enctype' =>'multipart/form-data'])); ?>


                 <div class="form-group">
                            <input type="file" name="file_import" class="file-import" id="file_import">
                            <small class="help-block help-block-for-file-import hide" data-bv-for="file-import" data-bv-result="INVALID" style=""></small>

                    </div>
                                <?php echo e(Form::close()); ?>


                <!--<a href="<?php echo e(route('import_custom_product')); ?>" type="file" class="btn btn-block btn-primary">Import Products</a>-->
            </div>
        </div>

        <div class="custom-margin">
            <table id="custom_product_list" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Last Updated Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($products)): ?>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($product->sku); ?></td>
                        <td><?php echo e(ucfirst($product->name)); ?></td>
                        <td><?php echo e($product->updated_at); ?></td>
                        <td> <a class="fa fa-trash custom-delete" style="color:red;cursor: pointer" title="Delete" data-id='<?php echo e($product->id); ?>'></a></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>
    $(document).on('click', '.custom-delete', function () {
        var _this = $(this);
        bootbox.confirm("Are you sure to delete?", function (result) {
            console.log(_this.attr('data-id'));
            if (result) {
                $.ajax({
                    url: "<?php echo e(route('delete_product')); ?>",
                    type: "get",
                    data: {id: _this.attr('data-id')},
                    success: function (data) {
                        location.reload();
                    }
                });
            }
        });
    });
    
    $(document).on('change', '.file-import', function (e) {
                var _this = $(this);

                e.preventDefault();
                var extension = $('.file-import').val().split('.').pop().toLowerCase();
           if ($.inArray(extension, ['csv', 'xls']) != -1) {                                        
                    _this.parents('.form-group').removeClass('has-error');
                    $(document).find('.help-block-for-file-import').html('');
                    $(document).find('.help-block-for-file-import').addClass('hide'); 
                        $(this).closest('form').submit();

                    // $(document).find('#save_import_file_data').submit();
                    // var file_data = $('#file_import').prop('files')[0];

            
                    // var form_data = new FormData();
                    // form_data.append('file', file_data);
                    // $.ajaxSetup({
                    //     headers: {
                    //         'X-CSRF-Token': $('meta[name=_token]').attr('content')
                    //     }
                    // });
                    //             $.ajax({
                    //                 url : '<?php echo e(route("save_import_file_data")); ?>',
                    //                 type : 'post',
                    //                 data : form_data ,
                    //                 contentType: false, // The content type used when sending data to the server.
                    //                 cache: false, // To unable request pages to be cached
                    //                 processData: false,
                    //                 success :function(data){
                    //                     console.log(data);
                    //                 },
                    //                 error :function(data){
                    //                     console.log('error'.data);
                    //                 }
                    //             });

            } else { 
                _this.parents('.form-group').addClass('has-error');
                $(document).find('.help-block-for-file-import').html('Invalid Excel/csv File!');
                $(document).find('.help-block-for-file-import').removeClass('hide');  
                }

       

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tannatech/public_html/cpq/resources/views/custom_products/list.blade.php ENDPATH**/ ?>